package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteKnownHostKeysRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest = {
    import DeleteKnownHostKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysRequest
      .wrap(buildAwsValue())
}
object DeleteKnownHostKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteKnownHostKeysRequest(instanceNameValue)
    def instanceNameValue: ResourceName
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysRequest.ReadOnly =
    new Wrapper(impl)
}
