package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateInstanceSnapshotRequest(
    instanceSnapshotName: ResourceName,
    instanceName: ResourceName,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest = {
    import CreateInstanceSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest
      .builder()
      .instanceSnapshotName(instanceSnapshotName: java.lang.String)
      .instanceName(instanceName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateInstanceSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotRequest(
        instanceSnapshotNameValue,
        instanceNameValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def instanceSnapshotNameValue: ResourceName
    def instanceNameValue: ResourceName
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def instanceSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceSnapshotNameValue)
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotRequest.ReadOnly {
    override def instanceSnapshotNameValue: ResourceName =
      impl.instanceSnapshotName(): ResourceName
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
