package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDiskSnapshotRequest(
    diskName: Option[ResourceName] = None,
    diskSnapshotName: ResourceName,
    instanceName: Option[ResourceName] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest = {
    import CreateDiskSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest
      .builder()
      .optionallyWith(diskName.map(value => value: java.lang.String))(
        _.diskName
      )
      .diskSnapshotName(diskSnapshotName: java.lang.String)
      .optionallyWith(instanceName.map(value => value: java.lang.String))(
        _.instanceName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateDiskSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotRequest(
        diskNameValue.map(value => value),
        diskSnapshotNameValue,
        instanceNameValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def diskNameValue: Option[ResourceName]
    def diskSnapshotNameValue: ResourceName
    def instanceNameValue: Option[ResourceName]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def diskName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("diskName", diskNameValue)
    def diskSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(diskSnapshotNameValue)
    def instanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("instanceName", instanceNameValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotRequest.ReadOnly {
    override def diskNameValue: Option[ResourceName] =
      scala.Option(impl.diskName()).map(value => value: ResourceName)
    override def diskSnapshotNameValue: ResourceName =
      impl.diskSnapshotName(): ResourceName
    override def instanceNameValue: Option[ResourceName] =
      scala.Option(impl.instanceName()).map(value => value: ResourceName)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
