package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.StringMax256
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateContactMethodRequest(
    protocol: io.github.vigoo.zioaws.lightsail.model.ContactProtocol,
    contactEndpoint: StringMax256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest = {
    import CreateContactMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest
      .builder()
      .protocol(protocol.unwrap)
      .contactEndpoint(contactEndpoint: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateContactMethodRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateContactMethodRequest
      .wrap(buildAwsValue())
}
object CreateContactMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateContactMethodRequest =
      io.github.vigoo.zioaws.lightsail.model
        .CreateContactMethodRequest(protocolValue, contactEndpointValue)
    def protocolValue: io.github.vigoo.zioaws.lightsail.model.ContactProtocol
    def contactEndpointValue: StringMax256
    def protocol: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.ContactProtocol
    ] = ZIO.succeed(protocolValue)
    def contactEndpoint: ZIO[Any, Nothing, StringMax256] =
      ZIO.succeed(contactEndpointValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateContactMethodRequest.ReadOnly {
    override def protocolValue
        : io.github.vigoo.zioaws.lightsail.model.ContactProtocol =
      io.github.vigoo.zioaws.lightsail.model.ContactProtocol
        .wrap(impl.protocol())
    override def contactEndpointValue: StringMax256 =
      impl.contactEndpoint(): StringMax256
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateContactMethodRequest.ReadOnly =
    new Wrapper(impl)
}
