package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait BehaviorEnum {
  def unwrap: software.amazon.awssdk.services.lightsail.model.BehaviorEnum
}
object BehaviorEnum {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.BehaviorEnum
  ): io.github.vigoo.zioaws.lightsail.model.BehaviorEnum = value match {
    case software.amazon.awssdk.services.lightsail.model.BehaviorEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.BehaviorEnum.DONT_CACHE =>
      val r = `dont-cache`
      r
    case software.amazon.awssdk.services.lightsail.model.BehaviorEnum.CACHE =>
      val r = cache
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.BehaviorEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BehaviorEnum =
      software.amazon.awssdk.services.lightsail.model.BehaviorEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object `dont-cache`
      extends io.github.vigoo.zioaws.lightsail.model.BehaviorEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BehaviorEnum =
      software.amazon.awssdk.services.lightsail.model.BehaviorEnum.DONT_CACHE
  }
  case object cache
      extends io.github.vigoo.zioaws.lightsail.model.BehaviorEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BehaviorEnum =
      software.amazon.awssdk.services.lightsail.model.BehaviorEnum.CACHE
  }
}
