package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.TimeOfDay
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AutoSnapshotAddOnRequest(
    snapshotTimeOfDay: Option[TimeOfDay] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest = {
    import AutoSnapshotAddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest
      .builder()
      .optionallyWith(snapshotTimeOfDay.map(value => value: java.lang.String))(
        _.snapshotTimeOfDay
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest
      .wrap(buildAwsValue())
}
object AutoSnapshotAddOnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest =
      io.github.vigoo.zioaws.lightsail.model
        .AutoSnapshotAddOnRequest(snapshotTimeOfDayValue.map(value => value))
    def snapshotTimeOfDayValue: Option[TimeOfDay]
    def snapshotTimeOfDay: ZIO[Any, AwsError, TimeOfDay] =
      AwsError.unwrapOptionField("snapshotTimeOfDay", snapshotTimeOfDayValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly {
    override def snapshotTimeOfDayValue: Option[TimeOfDay] =
      scala.Option(impl.snapshotTimeOfDay()).map(value => value: TimeOfDay)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest
  ): io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly =
    new Wrapper(impl)
}
