package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachStaticIpRequest(
    staticIpName: ResourceName,
    instanceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest = {
    import AttachStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest
      .builder()
      .staticIpName(staticIpName: java.lang.String)
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AttachStaticIpRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AttachStaticIpRequest
      .wrap(buildAwsValue())
}
object AttachStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AttachStaticIpRequest =
      io.github.vigoo.zioaws.lightsail.model
        .AttachStaticIpRequest(staticIpNameValue, instanceNameValue)
    def staticIpNameValue: ResourceName
    def instanceNameValue: ResourceName
    def staticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpNameValue)
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.AttachStaticIpRequest.ReadOnly {
    override def staticIpNameValue: ResourceName =
      impl.staticIpName(): ResourceName
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest
  ): io.github.vigoo.zioaws.lightsail.model.AttachStaticIpRequest.ReadOnly =
    new Wrapper(impl)
}
