package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachCertificateToDistributionRequest(
    distributionName: ResourceName,
    certificateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest = {
    import AttachCertificateToDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest
      .builder()
      .distributionName(distributionName: java.lang.String)
      .certificateName(certificateName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionRequest
      .wrap(buildAwsValue())
}
object AttachCertificateToDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionRequest =
      io.github.vigoo.zioaws.lightsail.model
        .AttachCertificateToDistributionRequest(
          distributionNameValue,
          certificateNameValue
        )
    def distributionNameValue: ResourceName
    def certificateNameValue: ResourceName
    def distributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionNameValue)
    def certificateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(certificateNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionRequest.ReadOnly {
    override def distributionNameValue: ResourceName =
      impl.distributionName(): ResourceName
    override def certificateNameValue: ResourceName =
      impl.certificateName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest
  ): io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
