package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateRelationalDatabaseParametersRequest(relationalDatabaseName: primitives.ResourceName, parameters: Iterable[RelationalDatabaseParameter]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest = {
    import UpdateRelationalDatabaseParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).parameters(parameters.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: UpdateRelationalDatabaseParametersRequest.ReadOnly = UpdateRelationalDatabaseParametersRequest.wrap(buildAwsValue())
}
object UpdateRelationalDatabaseParametersRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateRelationalDatabaseParametersRequest = UpdateRelationalDatabaseParametersRequest(relationalDatabaseNameValue, parametersValue.map { item => 
      item.editable
    })
    def relationalDatabaseNameValue: primitives.ResourceName
    def parametersValue: List[RelationalDatabaseParameter.ReadOnly]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def parameters: ZIO[Any, Nothing, List[RelationalDatabaseParameter.ReadOnly]] = ZIO.succeed(parametersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest) extends UpdateRelationalDatabaseParametersRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def parametersValue: List[RelationalDatabaseParameter.ReadOnly] = impl.parameters().asScala.map { item => 
      RelationalDatabaseParameter.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest): ReadOnly = new Wrapper(impl)
}