package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResourceReceivingAccess(name: scala.Option[primitives.NonEmptyString] = None, resourceType: scala.Option[primitives.NonEmptyString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess = {
    import ResourceReceivingAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(resourceType.map(value => value: java.lang.String))(_.resourceType).build()
  }
  def asReadOnly: ResourceReceivingAccess.ReadOnly = ResourceReceivingAccess.wrap(buildAwsValue())
}
object ResourceReceivingAccess {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResourceReceivingAccess = ResourceReceivingAccess(nameValue.map(value => value), resourceTypeValue.map(value => value))
    def nameValue: scala.Option[primitives.NonEmptyString]
    def resourceTypeValue: scala.Option[primitives.NonEmptyString]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess) extends ResourceReceivingAccess.ReadOnly {
    override def nameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.name()).map(value => value: primitives.NonEmptyString)
    override def resourceTypeValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.resourceType()).map(value => value: primitives.NonEmptyString)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess): ReadOnly = new Wrapper(impl)
}