package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RelationalDatabaseEvent(resource: scala.Option[primitives.ResourceName] = None, createdAt: scala.Option[primitives.IsoDate] = None, message: scala.Option[String] = None, eventCategories: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent = {
    import RelationalDatabaseEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent.builder().optionallyWith(resource.map(value => value: java.lang.String))(_.resource).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(message.map(value => value: java.lang.String))(_.message).optionallyWith(eventCategories.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.eventCategories).build()
  }
  def asReadOnly: RelationalDatabaseEvent.ReadOnly = RelationalDatabaseEvent.wrap(buildAwsValue())
}
object RelationalDatabaseEvent {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RelationalDatabaseEvent = RelationalDatabaseEvent(resourceValue.map(value => value), createdAtValue.map(value => value), messageValue.map(value => value), eventCategoriesValue.map(value => value))
    def resourceValue: scala.Option[primitives.ResourceName]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def messageValue: scala.Option[String]
    def eventCategoriesValue: scala.Option[List[String]]
    def resource: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resource", resourceValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
    def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent) extends RelationalDatabaseEvent.ReadOnly {
    override def resourceValue: scala.Option[primitives.ResourceName] = scala.Option(impl.resource()).map(value => value: primitives.ResourceName)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def messageValue: scala.Option[String] = scala.Option(impl.message()).map(value => value: String)
    override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent): ReadOnly = new Wrapper(impl)
}