package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class OpenInstancePublicPortsRequest(portInfo: PortInfo, instanceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest = {
    import OpenInstancePublicPortsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest.builder().portInfo(portInfo.buildAwsValue()).instanceName(instanceName: java.lang.String).build()
  }
  def asReadOnly: OpenInstancePublicPortsRequest.ReadOnly = OpenInstancePublicPortsRequest.wrap(buildAwsValue())
}
object OpenInstancePublicPortsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: OpenInstancePublicPortsRequest = OpenInstancePublicPortsRequest(portInfoValue.editable, instanceNameValue)
    def portInfoValue: PortInfo.ReadOnly
    def instanceNameValue: primitives.ResourceName
    def portInfo: ZIO[Any, Nothing, PortInfo.ReadOnly] = ZIO.succeed(portInfoValue)
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest) extends OpenInstancePublicPortsRequest.ReadOnly {
    override def portInfoValue: PortInfo.ReadOnly = PortInfo.wrap(impl.portInfo())
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest): ReadOnly = new Wrapper(impl)
}