package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LoadBalancerTlsCertificateSummary(name: scala.Option[primitives.ResourceName] = None, isAttached: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary = {
    import LoadBalancerTlsCertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(isAttached.map(value => value: java.lang.Boolean))(_.isAttached).build()
  }
  def asReadOnly: LoadBalancerTlsCertificateSummary.ReadOnly = LoadBalancerTlsCertificateSummary.wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LoadBalancerTlsCertificateSummary = LoadBalancerTlsCertificateSummary(nameValue.map(value => value), isAttachedValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def isAttachedValue: scala.Option[Boolean]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def isAttached: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isAttached", isAttachedValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary) extends LoadBalancerTlsCertificateSummary.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def isAttachedValue: scala.Option[Boolean] = scala.Option(impl.isAttached()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary): ReadOnly = new Wrapper(impl)
}