package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseSnapshotsResponse(relationalDatabaseSnapshots: scala.Option[Iterable[RelationalDatabaseSnapshot]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse = {
    import GetRelationalDatabaseSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse.builder().optionallyWith(relationalDatabaseSnapshots.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.relationalDatabaseSnapshots).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetRelationalDatabaseSnapshotsResponse.ReadOnly = GetRelationalDatabaseSnapshotsResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseSnapshotsResponse = GetRelationalDatabaseSnapshotsResponse(relationalDatabaseSnapshotsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def relationalDatabaseSnapshotsValue: scala.Option[List[RelationalDatabaseSnapshot.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def relationalDatabaseSnapshots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RelationalDatabaseSnapshot.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabaseSnapshots", relationalDatabaseSnapshotsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse) extends GetRelationalDatabaseSnapshotsResponse.ReadOnly {
    override def relationalDatabaseSnapshotsValue: scala.Option[List[RelationalDatabaseSnapshot.ReadOnly]] = scala.Option(impl.relationalDatabaseSnapshots()).map(value => value.asScala.map { item => 
      RelationalDatabaseSnapshot.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse): ReadOnly = new Wrapper(impl)
}