package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseMetricDataResponse(metricName: scala.Option[RelationalDatabaseMetricName] = None, metricData: scala.Option[Iterable[MetricDatapoint]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse = {
    import GetRelationalDatabaseMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse.builder().optionallyWith(metricName.map(value => value.unwrap))(_.metricName).optionallyWith(metricData.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.metricData).build()
  }
  def asReadOnly: GetRelationalDatabaseMetricDataResponse.ReadOnly = GetRelationalDatabaseMetricDataResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseMetricDataResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseMetricDataResponse = GetRelationalDatabaseMetricDataResponse(metricNameValue.map(value => value), metricDataValue.map(value => value.map { item => 
      item.editable
    }))
    def metricNameValue: scala.Option[RelationalDatabaseMetricName]
    def metricDataValue: scala.Option[List[MetricDatapoint.ReadOnly]]
    def metricName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RelationalDatabaseMetricName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metricName", metricNameValue)
    def metricData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[MetricDatapoint.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metricData", metricDataValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse) extends GetRelationalDatabaseMetricDataResponse.ReadOnly {
    override def metricNameValue: scala.Option[RelationalDatabaseMetricName] = scala.Option(impl.metricName()).map(value => RelationalDatabaseMetricName.wrap(value))
    override def metricDataValue: scala.Option[List[MetricDatapoint.ReadOnly]] = scala.Option(impl.metricData()).map(value => value.asScala.map { item => 
      MetricDatapoint.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse): ReadOnly = new Wrapper(impl)
}