package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerImagesResponse(containerImages: scala.Option[Iterable[ContainerImage]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse = {
    import GetContainerImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse.builder().optionallyWith(containerImages.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.containerImages).build()
  }
  def asReadOnly: GetContainerImagesResponse.ReadOnly = GetContainerImagesResponse.wrap(buildAwsValue())
}
object GetContainerImagesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerImagesResponse = GetContainerImagesResponse(containerImagesValue.map(value => value.map { item => 
      item.editable
    }))
    def containerImagesValue: scala.Option[List[ContainerImage.ReadOnly]]
    def containerImages: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ContainerImage.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containerImages", containerImagesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse) extends GetContainerImagesResponse.ReadOnly {
    override def containerImagesValue: scala.Option[List[ContainerImage.ReadOnly]] = scala.Option(impl.containerImages()).map(value => value.asScala.map { item => 
      ContainerImage.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse): ReadOnly = new Wrapper(impl)
}