package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DistributionBundle(bundleId: scala.Option[String] = None, name: scala.Option[String] = None, price: scala.Option[Float] = None, transferPerMonthInGb: scala.Option[primitives.Integer] = None, isActive: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DistributionBundle = {
    import DistributionBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DistributionBundle.builder().optionallyWith(bundleId.map(value => value: java.lang.String))(_.bundleId).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(price.map(value => value: java.lang.Float))(_.price).optionallyWith(transferPerMonthInGb.map(value => value: java.lang.Integer))(_.transferPerMonthInGb).optionallyWith(isActive.map(value => value: java.lang.Boolean))(_.isActive).build()
  }
  def asReadOnly: DistributionBundle.ReadOnly = DistributionBundle.wrap(buildAwsValue())
}
object DistributionBundle {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DistributionBundle] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DistributionBundle = DistributionBundle(bundleIdValue.map(value => value), nameValue.map(value => value), priceValue.map(value => value), transferPerMonthInGbValue.map(value => value), isActiveValue.map(value => value))
    def bundleIdValue: scala.Option[String]
    def nameValue: scala.Option[String]
    def priceValue: scala.Option[Float]
    def transferPerMonthInGbValue: scala.Option[primitives.Integer]
    def isActiveValue: scala.Option[Boolean]
    def bundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def price: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("price", priceValue)
    def transferPerMonthInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("transferPerMonthInGb", transferPerMonthInGbValue)
    def isActive: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isActive", isActiveValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DistributionBundle) extends DistributionBundle.ReadOnly {
    override def bundleIdValue: scala.Option[String] = scala.Option(impl.bundleId()).map(value => value: String)
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def priceValue: scala.Option[Float] = scala.Option(impl.price()).map(value => value: Float)
    override def transferPerMonthInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.transferPerMonthInGb()).map(value => value: primitives.Integer)
    override def isActiveValue: scala.Option[Boolean] = scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DistributionBundle): ReadOnly = new Wrapper(impl)
}