package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLoadBalancerRequest(loadBalancerName: primitives.ResourceName, instancePort: primitives.Port, healthCheckPath: scala.Option[String] = None, certificateName: scala.Option[primitives.ResourceName] = None, certificateDomainName: scala.Option[primitives.DomainName] = None, certificateAlternativeNames: scala.Option[Iterable[primitives.DomainName]] = None, tags: scala.Option[Iterable[Tag]] = None, ipAddressType: scala.Option[IpAddressType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest = {
    import CreateLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).instancePort(instancePort: java.lang.Integer).optionallyWith(healthCheckPath.map(value => value: java.lang.String))(_.healthCheckPath).optionallyWith(certificateName.map(value => value: java.lang.String))(_.certificateName).optionallyWith(certificateDomainName.map(value => value: java.lang.String))(_.certificateDomainName).optionallyWith(certificateAlternativeNames.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.certificateAlternativeNames).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType).build()
  }
  def asReadOnly: CreateLoadBalancerRequest.ReadOnly = CreateLoadBalancerRequest.wrap(buildAwsValue())
}
object CreateLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLoadBalancerRequest = CreateLoadBalancerRequest(loadBalancerNameValue, instancePortValue, healthCheckPathValue.map(value => value), certificateNameValue.map(value => value), certificateDomainNameValue.map(value => value), certificateAlternativeNamesValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), ipAddressTypeValue.map(value => value))
    def loadBalancerNameValue: primitives.ResourceName
    def instancePortValue: primitives.Port
    def healthCheckPathValue: scala.Option[String]
    def certificateNameValue: scala.Option[primitives.ResourceName]
    def certificateDomainNameValue: scala.Option[primitives.DomainName]
    def certificateAlternativeNamesValue: scala.Option[List[primitives.DomainName]]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def ipAddressTypeValue: scala.Option[IpAddressType]
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
    def instancePort: ZIO[Any, Nothing, primitives.Port] = ZIO.succeed(instancePortValue)
    def healthCheckPath: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("healthCheckPath", healthCheckPathValue)
    def certificateName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateName", certificateNameValue)
    def certificateDomainName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DomainName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateDomainName", certificateDomainNameValue)
    def certificateAlternativeNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.DomainName]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateAlternativeNames", certificateAlternativeNamesValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def ipAddressType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IpAddressType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest) extends CreateLoadBalancerRequest.ReadOnly {
    override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName
    override def instancePortValue: primitives.Port = impl.instancePort(): primitives.Port
    override def healthCheckPathValue: scala.Option[String] = scala.Option(impl.healthCheckPath()).map(value => value: String)
    override def certificateNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.certificateName()).map(value => value: primitives.ResourceName)
    override def certificateDomainNameValue: scala.Option[primitives.DomainName] = scala.Option(impl.certificateDomainName()).map(value => value: primitives.DomainName)
    override def certificateAlternativeNamesValue: scala.Option[List[primitives.DomainName]] = scala.Option(impl.certificateAlternativeNames()).map(value => value.asScala.map { item => 
      item: primitives.DomainName
    }.toList)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def ipAddressTypeValue: scala.Option[IpAddressType] = scala.Option(impl.ipAddressType()).map(value => IpAddressType.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest): ReadOnly = new Wrapper(impl)
}