package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class BucketState(code: scala.Option[primitives.NonEmptyString] = None, message: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.BucketState = {
    import BucketState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketState.builder().optionallyWith(code.map(value => value: java.lang.String))(_.code).optionallyWith(message.map(value => value: java.lang.String))(_.message).build()
  }
  def asReadOnly: BucketState.ReadOnly = BucketState.wrap(buildAwsValue())
}
object BucketState {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.BucketState] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: BucketState = BucketState(codeValue.map(value => value), messageValue.map(value => value))
    def codeValue: scala.Option[primitives.NonEmptyString]
    def messageValue: scala.Option[String]
    def code: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("code", codeValue)
    def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.BucketState) extends BucketState.ReadOnly {
    override def codeValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.code()).map(value => value: primitives.NonEmptyString)
    override def messageValue: scala.Option[String] = scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.BucketState): ReadOnly = new Wrapper(impl)
}