package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AllocateStaticIpRequest(staticIpName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest = {
    import AllocateStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest.builder().staticIpName(staticIpName: java.lang.String).build()
  }
  def asReadOnly: AllocateStaticIpRequest.ReadOnly = AllocateStaticIpRequest.wrap(buildAwsValue())
}
object AllocateStaticIpRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AllocateStaticIpRequest = AllocateStaticIpRequest(staticIpNameValue)
    def staticIpNameValue: primitives.ResourceName
    def staticIpName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(staticIpNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest) extends AllocateStaticIpRequest.ReadOnly { override def staticIpNameValue: primitives.ResourceName = impl.staticIpName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest): ReadOnly = new Wrapper(impl)
}