package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RenewalSummary(domainValidationRecords: scala.Option[Iterable[DomainValidationRecord]] = None, renewalStatus: scala.Option[RenewalStatus] = None, renewalStatusReason: scala.Option[primitives.RenewalStatusReason] = None, updatedAt: scala.Option[primitives.IsoDate] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RenewalSummary = {
    import RenewalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RenewalSummary.builder().optionallyWith(domainValidationRecords.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.domainValidationRecords).optionallyWith(renewalStatus.map(value => value.unwrap))(_.renewalStatus).optionallyWith(renewalStatusReason.map(value => value: java.lang.String))(_.renewalStatusReason).optionallyWith(updatedAt.map(value => value: java.time.Instant))(_.updatedAt).build()
  }
  def asReadOnly: RenewalSummary.ReadOnly = RenewalSummary.wrap(buildAwsValue())
}
object RenewalSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RenewalSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RenewalSummary = RenewalSummary(domainValidationRecordsValue.map(value => value.map { item => 
      item.editable
    }), renewalStatusValue.map(value => value), renewalStatusReasonValue.map(value => value), updatedAtValue.map(value => value))
    def domainValidationRecordsValue: scala.Option[List[DomainValidationRecord.ReadOnly]]
    def renewalStatusValue: scala.Option[RenewalStatus]
    def renewalStatusReasonValue: scala.Option[primitives.RenewalStatusReason]
    def updatedAtValue: scala.Option[primitives.IsoDate]
    def domainValidationRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DomainValidationRecord.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainValidationRecords", domainValidationRecordsValue)
    def renewalStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RenewalStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("renewalStatus", renewalStatusValue)
    def renewalStatusReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RenewalStatusReason] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("renewalStatusReason", renewalStatusReasonValue)
    def updatedAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("updatedAt", updatedAtValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RenewalSummary) extends RenewalSummary.ReadOnly {
    override def domainValidationRecordsValue: scala.Option[List[DomainValidationRecord.ReadOnly]] = scala.Option(impl.domainValidationRecords()).map(value => value.asScala.map { item => 
      DomainValidationRecord.wrap(item)
    }.toList)
    override def renewalStatusValue: scala.Option[RenewalStatus] = scala.Option(impl.renewalStatus()).map(value => RenewalStatus.wrap(value))
    override def renewalStatusReasonValue: scala.Option[primitives.RenewalStatusReason] = scala.Option(impl.renewalStatusReason()).map(value => value: primitives.RenewalStatusReason)
    override def updatedAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.updatedAt()).map(value => value: primitives.IsoDate)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RenewalSummary): ReadOnly = new Wrapper(impl)
}