package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RelationalDatabaseBlueprint(blueprintId: scala.Option[String] = None, engine: scala.Option[RelationalDatabaseEngine] = None, engineVersion: scala.Option[String] = None, engineDescription: scala.Option[String] = None, engineVersionDescription: scala.Option[String] = None, isEngineDefault: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint = {
    import RelationalDatabaseBlueprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint.builder().optionallyWith(blueprintId.map(value => value: java.lang.String))(_.blueprintId).optionallyWith(engine.map(value => value.unwrap))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(engineDescription.map(value => value: java.lang.String))(_.engineDescription).optionallyWith(engineVersionDescription.map(value => value: java.lang.String))(_.engineVersionDescription).optionallyWith(isEngineDefault.map(value => value: java.lang.Boolean))(_.isEngineDefault).build()
  }
  def asReadOnly: RelationalDatabaseBlueprint.ReadOnly = RelationalDatabaseBlueprint.wrap(buildAwsValue())
}
object RelationalDatabaseBlueprint {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RelationalDatabaseBlueprint = RelationalDatabaseBlueprint(blueprintIdValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), engineDescriptionValue.map(value => value), engineVersionDescriptionValue.map(value => value), isEngineDefaultValue.map(value => value))
    def blueprintIdValue: scala.Option[String]
    def engineValue: scala.Option[RelationalDatabaseEngine]
    def engineVersionValue: scala.Option[String]
    def engineDescriptionValue: scala.Option[String]
    def engineVersionDescriptionValue: scala.Option[String]
    def isEngineDefaultValue: scala.Option[Boolean]
    def blueprintId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("blueprintId", blueprintIdValue)
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RelationalDatabaseEngine] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def engineDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineDescription", engineDescriptionValue)
    def engineVersionDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersionDescription", engineVersionDescriptionValue)
    def isEngineDefault: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isEngineDefault", isEngineDefaultValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint) extends RelationalDatabaseBlueprint.ReadOnly {
    override def blueprintIdValue: scala.Option[String] = scala.Option(impl.blueprintId()).map(value => value: String)
    override def engineValue: scala.Option[RelationalDatabaseEngine] = scala.Option(impl.engine()).map(value => RelationalDatabaseEngine.wrap(value))
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def engineDescriptionValue: scala.Option[String] = scala.Option(impl.engineDescription()).map(value => value: String)
    override def engineVersionDescriptionValue: scala.Option[String] = scala.Option(impl.engineVersionDescription()).map(value => value: String)
    override def isEngineDefaultValue: scala.Option[Boolean] = scala.Option(impl.isEngineDefault()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint): ReadOnly = new Wrapper(impl)
}