package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LoadBalancerTlsCertificate(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, tags: scala.Option[Iterable[Tag]] = None, loadBalancerName: scala.Option[primitives.ResourceName] = None, isAttached: scala.Option[Boolean] = None, status: scala.Option[LoadBalancerTlsCertificateStatus] = None, domainName: scala.Option[primitives.DomainName] = None, domainValidationRecords: scala.Option[Iterable[LoadBalancerTlsCertificateDomainValidationRecord]] = None, failureReason: scala.Option[LoadBalancerTlsCertificateFailureReason] = None, issuedAt: scala.Option[primitives.IsoDate] = None, issuer: scala.Option[primitives.NonEmptyString] = None, keyAlgorithm: scala.Option[primitives.NonEmptyString] = None, notAfter: scala.Option[primitives.IsoDate] = None, notBefore: scala.Option[primitives.IsoDate] = None, renewalSummary: scala.Option[LoadBalancerTlsCertificateRenewalSummary] = None, revocationReason: scala.Option[LoadBalancerTlsCertificateRevocationReason] = None, revokedAt: scala.Option[primitives.IsoDate] = None, serial: scala.Option[primitives.NonEmptyString] = None, signatureAlgorithm: scala.Option[primitives.NonEmptyString] = None, subject: scala.Option[primitives.NonEmptyString] = None, subjectAlternativeNames: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate = {
    import LoadBalancerTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(loadBalancerName.map(value => value: java.lang.String))(_.loadBalancerName).optionallyWith(isAttached.map(value => value: java.lang.Boolean))(_.isAttached).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(domainName.map(value => value: java.lang.String))(_.domainName).optionallyWith(domainValidationRecords.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.domainValidationRecords).optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason).optionallyWith(issuedAt.map(value => value: java.time.Instant))(_.issuedAt).optionallyWith(issuer.map(value => value: java.lang.String))(_.issuer).optionallyWith(keyAlgorithm.map(value => value: java.lang.String))(_.keyAlgorithm).optionallyWith(notAfter.map(value => value: java.time.Instant))(_.notAfter).optionallyWith(notBefore.map(value => value: java.time.Instant))(_.notBefore).optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(_.renewalSummary).optionallyWith(revocationReason.map(value => value.unwrap))(_.revocationReason).optionallyWith(revokedAt.map(value => value: java.time.Instant))(_.revokedAt).optionallyWith(serial.map(value => value: java.lang.String))(_.serial).optionallyWith(signatureAlgorithm.map(value => value: java.lang.String))(_.signatureAlgorithm).optionallyWith(subject.map(value => value: java.lang.String))(_.subject).optionallyWith(subjectAlternativeNames.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.subjectAlternativeNames).build()
  }
  def asReadOnly: LoadBalancerTlsCertificate.ReadOnly = LoadBalancerTlsCertificate.wrap(buildAwsValue())
}
object LoadBalancerTlsCertificate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LoadBalancerTlsCertificate = LoadBalancerTlsCertificate(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), loadBalancerNameValue.map(value => value), isAttachedValue.map(value => value), statusValue.map(value => value), domainNameValue.map(value => value), domainValidationRecordsValue.map(value => value.map { item => 
      item.editable
    }), failureReasonValue.map(value => value), issuedAtValue.map(value => value), issuerValue.map(value => value), keyAlgorithmValue.map(value => value), notAfterValue.map(value => value), notBeforeValue.map(value => value), renewalSummaryValue.map(value => value.editable), revocationReasonValue.map(value => value), revokedAtValue.map(value => value), serialValue.map(value => value), signatureAlgorithmValue.map(value => value), subjectValue.map(value => value), subjectAlternativeNamesValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def loadBalancerNameValue: scala.Option[primitives.ResourceName]
    def isAttachedValue: scala.Option[Boolean]
    def statusValue: scala.Option[LoadBalancerTlsCertificateStatus]
    def domainNameValue: scala.Option[primitives.DomainName]
    def domainValidationRecordsValue: scala.Option[List[LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly]]
    def failureReasonValue: scala.Option[LoadBalancerTlsCertificateFailureReason]
    def issuedAtValue: scala.Option[primitives.IsoDate]
    def issuerValue: scala.Option[primitives.NonEmptyString]
    def keyAlgorithmValue: scala.Option[primitives.NonEmptyString]
    def notAfterValue: scala.Option[primitives.IsoDate]
    def notBeforeValue: scala.Option[primitives.IsoDate]
    def renewalSummaryValue: scala.Option[LoadBalancerTlsCertificateRenewalSummary.ReadOnly]
    def revocationReasonValue: scala.Option[LoadBalancerTlsCertificateRevocationReason]
    def revokedAtValue: scala.Option[primitives.IsoDate]
    def serialValue: scala.Option[primitives.NonEmptyString]
    def signatureAlgorithmValue: scala.Option[primitives.NonEmptyString]
    def subjectValue: scala.Option[primitives.NonEmptyString]
    def subjectAlternativeNamesValue: scala.Option[List[String]]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def loadBalancerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loadBalancerName", loadBalancerNameValue)
    def isAttached: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isAttached", isAttachedValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerTlsCertificateStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def domainName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DomainName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainName", domainNameValue)
    def domainValidationRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainValidationRecords", domainValidationRecordsValue)
    def failureReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerTlsCertificateFailureReason] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("failureReason", failureReasonValue)
    def issuedAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("issuedAt", issuedAtValue)
    def issuer: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("issuer", issuerValue)
    def keyAlgorithm: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithmValue)
    def notAfter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notAfter", notAfterValue)
    def notBefore: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notBefore", notBeforeValue)
    def renewalSummary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerTlsCertificateRenewalSummary.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("renewalSummary", renewalSummaryValue)
    def revocationReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerTlsCertificateRevocationReason] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("revocationReason", revocationReasonValue)
    def revokedAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("revokedAt", revokedAtValue)
    def serial: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serial", serialValue)
    def signatureAlgorithm: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithmValue)
    def subject: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subject", subjectValue)
    def subjectAlternativeNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subjectAlternativeNames", subjectAlternativeNamesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate) extends LoadBalancerTlsCertificate.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def loadBalancerNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.loadBalancerName()).map(value => value: primitives.ResourceName)
    override def isAttachedValue: scala.Option[Boolean] = scala.Option(impl.isAttached()).map(value => value: Boolean)
    override def statusValue: scala.Option[LoadBalancerTlsCertificateStatus] = scala.Option(impl.status()).map(value => LoadBalancerTlsCertificateStatus.wrap(value))
    override def domainNameValue: scala.Option[primitives.DomainName] = scala.Option(impl.domainName()).map(value => value: primitives.DomainName)
    override def domainValidationRecordsValue: scala.Option[List[LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly]] = scala.Option(impl.domainValidationRecords()).map(value => value.asScala.map { item => 
      LoadBalancerTlsCertificateDomainValidationRecord.wrap(item)
    }.toList)
    override def failureReasonValue: scala.Option[LoadBalancerTlsCertificateFailureReason] = scala.Option(impl.failureReason()).map(value => LoadBalancerTlsCertificateFailureReason.wrap(value))
    override def issuedAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.issuedAt()).map(value => value: primitives.IsoDate)
    override def issuerValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.issuer()).map(value => value: primitives.NonEmptyString)
    override def keyAlgorithmValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.keyAlgorithm()).map(value => value: primitives.NonEmptyString)
    override def notAfterValue: scala.Option[primitives.IsoDate] = scala.Option(impl.notAfter()).map(value => value: primitives.IsoDate)
    override def notBeforeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.notBefore()).map(value => value: primitives.IsoDate)
    override def renewalSummaryValue: scala.Option[LoadBalancerTlsCertificateRenewalSummary.ReadOnly] = scala.Option(impl.renewalSummary()).map(value => LoadBalancerTlsCertificateRenewalSummary.wrap(value))
    override def revocationReasonValue: scala.Option[LoadBalancerTlsCertificateRevocationReason] = scala.Option(impl.revocationReason()).map(value => LoadBalancerTlsCertificateRevocationReason.wrap(value))
    override def revokedAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.revokedAt()).map(value => value: primitives.IsoDate)
    override def serialValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.serial()).map(value => value: primitives.NonEmptyString)
    override def signatureAlgorithmValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.signatureAlgorithm()).map(value => value: primitives.NonEmptyString)
    override def subjectValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.subject()).map(value => value: primitives.NonEmptyString)
    override def subjectAlternativeNamesValue: scala.Option[List[String]] = scala.Option(impl.subjectAlternativeNames()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate): ReadOnly = new Wrapper(impl)
}