package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstanceNetworking(monthlyTransfer: scala.Option[MonthlyTransfer] = None, ports: scala.Option[Iterable[InstancePortInfo]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstanceNetworking = {
    import InstanceNetworking.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceNetworking.builder().optionallyWith(monthlyTransfer.map(value => value.buildAwsValue()))(_.monthlyTransfer).optionallyWith(ports.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.ports).build()
  }
  def asReadOnly: InstanceNetworking.ReadOnly = InstanceNetworking.wrap(buildAwsValue())
}
object InstanceNetworking {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstanceNetworking] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstanceNetworking = InstanceNetworking(monthlyTransferValue.map(value => value.editable), portsValue.map(value => value.map { item => 
      item.editable
    }))
    def monthlyTransferValue: scala.Option[MonthlyTransfer.ReadOnly]
    def portsValue: scala.Option[List[InstancePortInfo.ReadOnly]]
    def monthlyTransfer: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MonthlyTransfer.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monthlyTransfer", monthlyTransferValue)
    def ports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[InstancePortInfo.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ports", portsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstanceNetworking) extends InstanceNetworking.ReadOnly {
    override def monthlyTransferValue: scala.Option[MonthlyTransfer.ReadOnly] = scala.Option(impl.monthlyTransfer()).map(value => MonthlyTransfer.wrap(value))
    override def portsValue: scala.Option[List[InstancePortInfo.ReadOnly]] = scala.Option(impl.ports()).map(value => value.asScala.map { item => 
      InstancePortInfo.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstanceNetworking): ReadOnly = new Wrapper(impl)
}