package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait InstanceHealthState { def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceHealthState }
object InstanceHealthState {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.InstanceHealthState): InstanceHealthState = value match {
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.INITIAL =>
      val r = initial
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.HEALTHY =>
      val r = healthy
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNHEALTHY =>
      val r = unhealthy
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNUSED =>
      val r = unused
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.DRAINING =>
      val r = draining
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNAVAILABLE =>
      val r = unavailable
      r
  }
  case object unknownToSdkVersion extends InstanceHealthState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceHealthState = software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNKNOWN_TO_SDK_VERSION }
  case object initial extends InstanceHealthState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceHealthState = software.amazon.awssdk.services.lightsail.model.InstanceHealthState.INITIAL }
  case object healthy extends InstanceHealthState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceHealthState = software.amazon.awssdk.services.lightsail.model.InstanceHealthState.HEALTHY }
  case object unhealthy extends InstanceHealthState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceHealthState = software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNHEALTHY }
  case object unused extends InstanceHealthState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceHealthState = software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNUSED }
  case object draining extends InstanceHealthState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceHealthState = software.amazon.awssdk.services.lightsail.model.InstanceHealthState.DRAINING }
  case object unavailable extends InstanceHealthState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceHealthState = software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNAVAILABLE }
}