package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ImportKeyPairRequest(keyPairName: primitives.ResourceName, publicKeyBase64: primitives.Base64) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest = {
    import ImportKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest.builder().keyPairName(keyPairName: java.lang.String).publicKeyBase64(publicKeyBase64: java.lang.String).build()
  }
  def asReadOnly: ImportKeyPairRequest.ReadOnly = ImportKeyPairRequest.wrap(buildAwsValue())
}
object ImportKeyPairRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ImportKeyPairRequest = ImportKeyPairRequest(keyPairNameValue, publicKeyBase64Value)
    def keyPairNameValue: primitives.ResourceName
    def publicKeyBase64Value: primitives.Base64
    def keyPairName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(keyPairNameValue)
    def publicKeyBase64: ZIO[Any, Nothing, primitives.Base64] = ZIO.succeed(publicKeyBase64Value)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest) extends ImportKeyPairRequest.ReadOnly {
    override def keyPairNameValue: primitives.ResourceName = impl.keyPairName(): primitives.ResourceName
    override def publicKeyBase64Value: primitives.Base64 = impl.publicKeyBase64(): primitives.Base64
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest): ReadOnly = new Wrapper(impl)
}