package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseEventsRequest(relationalDatabaseName: primitives.ResourceName, durationInMinutes: scala.Option[primitives.Integer] = None, pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest = {
    import GetRelationalDatabaseEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).optionallyWith(durationInMinutes.map(value => value: java.lang.Integer))(_.durationInMinutes).optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetRelationalDatabaseEventsRequest.ReadOnly = GetRelationalDatabaseEventsRequest.wrap(buildAwsValue())
}
object GetRelationalDatabaseEventsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseEventsRequest = GetRelationalDatabaseEventsRequest(relationalDatabaseNameValue, durationInMinutesValue.map(value => value), pageTokenValue.map(value => value))
    def relationalDatabaseNameValue: primitives.ResourceName
    def durationInMinutesValue: scala.Option[primitives.Integer]
    def pageTokenValue: scala.Option[String]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def durationInMinutes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("durationInMinutes", durationInMinutesValue)
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest) extends GetRelationalDatabaseEventsRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def durationInMinutesValue: scala.Option[primitives.Integer] = scala.Option(impl.durationInMinutes()).map(value => value: primitives.Integer)
    override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest): ReadOnly = new Wrapper(impl)
}