package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetOperationsForResourceResponse(operations: scala.Option[Iterable[Operation]] = None, nextPageCount: scala.Option[String] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse = {
    import GetOperationsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse.builder().optionallyWith(operations.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.operations).optionallyWith(nextPageCount.map(value => value: java.lang.String))(_.nextPageCount).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetOperationsForResourceResponse.ReadOnly = GetOperationsForResourceResponse.wrap(buildAwsValue())
}
object GetOperationsForResourceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetOperationsForResourceResponse = GetOperationsForResourceResponse(operationsValue.map(value => value.map { item => 
      item.editable
    }), nextPageCountValue.map(value => value), nextPageTokenValue.map(value => value))
    def operationsValue: scala.Option[List[Operation.ReadOnly]]
    def nextPageCountValue: scala.Option[String]
    def nextPageTokenValue: scala.Option[String]
    def operations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Operation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operations", operationsValue)
    def nextPageCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageCount", nextPageCountValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse) extends GetOperationsForResourceResponse.ReadOnly {
    override def operationsValue: scala.Option[List[Operation.ReadOnly]] = scala.Option(impl.operations()).map(value => value.asScala.map { item => 
      Operation.wrap(item)
    }.toList)
    override def nextPageCountValue: scala.Option[String] = scala.Option(impl.nextPageCount()).map(value => value: String)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse): ReadOnly = new Wrapper(impl)
}