package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDistributionBundlesResponse(bundles: scala.Option[Iterable[DistributionBundle]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse = {
    import GetDistributionBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse.builder().optionallyWith(bundles.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.bundles).build()
  }
  def asReadOnly: GetDistributionBundlesResponse.ReadOnly = GetDistributionBundlesResponse.wrap(buildAwsValue())
}
object GetDistributionBundlesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDistributionBundlesResponse = GetDistributionBundlesResponse(bundlesValue.map(value => value.map { item => 
      item.editable
    }))
    def bundlesValue: scala.Option[List[DistributionBundle.ReadOnly]]
    def bundles: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DistributionBundle.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundles", bundlesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse) extends GetDistributionBundlesResponse.ReadOnly {
    override def bundlesValue: scala.Option[List[DistributionBundle.ReadOnly]] = scala.Option(impl.bundles()).map(value => value.asScala.map { item => 
      DistributionBundle.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse): ReadOnly = new Wrapper(impl)
}