package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContactMethodsResponse(contactMethods: scala.Option[Iterable[ContactMethod]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse = {
    import GetContactMethodsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse.builder().optionallyWith(contactMethods.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.contactMethods).build()
  }
  def asReadOnly: GetContactMethodsResponse.ReadOnly = GetContactMethodsResponse.wrap(buildAwsValue())
}
object GetContactMethodsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContactMethodsResponse = GetContactMethodsResponse(contactMethodsValue.map(value => value.map { item => 
      item.editable
    }))
    def contactMethodsValue: scala.Option[List[ContactMethod.ReadOnly]]
    def contactMethods: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ContactMethod.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("contactMethods", contactMethodsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse) extends GetContactMethodsResponse.ReadOnly {
    override def contactMethodsValue: scala.Option[List[ContactMethod.ReadOnly]] = scala.Option(impl.contactMethods()).map(value => value.asScala.map { item => 
      ContactMethod.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse): ReadOnly = new Wrapper(impl)
}