package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetCloudFormationStackRecordsResponse(cloudFormationStackRecords: scala.Option[Iterable[CloudFormationStackRecord]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse = {
    import GetCloudFormationStackRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse.builder().optionallyWith(cloudFormationStackRecords.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.cloudFormationStackRecords).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetCloudFormationStackRecordsResponse.ReadOnly = GetCloudFormationStackRecordsResponse.wrap(buildAwsValue())
}
object GetCloudFormationStackRecordsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetCloudFormationStackRecordsResponse = GetCloudFormationStackRecordsResponse(cloudFormationStackRecordsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def cloudFormationStackRecordsValue: scala.Option[List[CloudFormationStackRecord.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def cloudFormationStackRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CloudFormationStackRecord.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cloudFormationStackRecords", cloudFormationStackRecordsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse) extends GetCloudFormationStackRecordsResponse.ReadOnly {
    override def cloudFormationStackRecordsValue: scala.Option[List[CloudFormationStackRecord.ReadOnly]] = scala.Option(impl.cloudFormationStackRecords()).map(value => value.asScala.map { item => 
      CloudFormationStackRecord.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse): ReadOnly = new Wrapper(impl)
}