package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetCertificatesRequest(certificateStatuses: scala.Option[Iterable[CertificateStatus]] = None, includeCertificateDetails: scala.Option[primitives.IncludeCertificateDetails] = None, certificateName: scala.Option[primitives.CertificateName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest = {
    import GetCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest.builder().optionallyWith(certificateStatuses.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.certificateStatusesWithStrings).optionallyWith(includeCertificateDetails.map(value => value: java.lang.Boolean))(_.includeCertificateDetails).optionallyWith(certificateName.map(value => value: java.lang.String))(_.certificateName).build()
  }
  def asReadOnly: GetCertificatesRequest.ReadOnly = GetCertificatesRequest.wrap(buildAwsValue())
}
object GetCertificatesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetCertificatesRequest = GetCertificatesRequest(certificateStatusesValue.map(value => value), includeCertificateDetailsValue.map(value => value), certificateNameValue.map(value => value))
    def certificateStatusesValue: scala.Option[List[CertificateStatus]]
    def includeCertificateDetailsValue: scala.Option[primitives.IncludeCertificateDetails]
    def certificateNameValue: scala.Option[primitives.CertificateName]
    def certificateStatuses: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CertificateStatus]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateStatuses", certificateStatusesValue)
    def includeCertificateDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IncludeCertificateDetails] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeCertificateDetails", includeCertificateDetailsValue)
    def certificateName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CertificateName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateName", certificateNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest) extends GetCertificatesRequest.ReadOnly {
    override def certificateStatusesValue: scala.Option[List[CertificateStatus]] = scala.Option(impl.certificateStatuses()).map(value => value.asScala.map { item => 
      CertificateStatus.wrap(item)
    }.toList)
    override def includeCertificateDetailsValue: scala.Option[primitives.IncludeCertificateDetails] = scala.Option(impl.includeCertificateDetails()).map(value => value: primitives.IncludeCertificateDetails)
    override def certificateNameValue: scala.Option[primitives.CertificateName] = scala.Option(impl.certificateName()).map(value => value: primitives.CertificateName)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest): ReadOnly = new Wrapper(impl)
}