package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetActiveNamesResponse(activeNames: scala.Option[Iterable[String]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse = {
    import GetActiveNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse.builder().optionallyWith(activeNames.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.activeNames).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetActiveNamesResponse.ReadOnly = GetActiveNamesResponse.wrap(buildAwsValue())
}
object GetActiveNamesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetActiveNamesResponse = GetActiveNamesResponse(activeNamesValue.map(value => value), nextPageTokenValue.map(value => value))
    def activeNamesValue: scala.Option[List[String]]
    def nextPageTokenValue: scala.Option[String]
    def activeNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activeNames", activeNamesValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse) extends GetActiveNamesResponse.ReadOnly {
    override def activeNamesValue: scala.Option[List[String]] = scala.Option(impl.activeNames()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse): ReadOnly = new Wrapper(impl)
}