package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DomainValidationRecord(domainName: scala.Option[primitives.DomainName] = None, resourceRecord: scala.Option[ResourceRecord] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DomainValidationRecord = {
    import DomainValidationRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DomainValidationRecord.builder().optionallyWith(domainName.map(value => value: java.lang.String))(_.domainName).optionallyWith(resourceRecord.map(value => value.buildAwsValue()))(_.resourceRecord).build()
  }
  def asReadOnly: DomainValidationRecord.ReadOnly = DomainValidationRecord.wrap(buildAwsValue())
}
object DomainValidationRecord {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DomainValidationRecord] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DomainValidationRecord = DomainValidationRecord(domainNameValue.map(value => value), resourceRecordValue.map(value => value.editable))
    def domainNameValue: scala.Option[primitives.DomainName]
    def resourceRecordValue: scala.Option[ResourceRecord.ReadOnly]
    def domainName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DomainName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainName", domainNameValue)
    def resourceRecord: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceRecord.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceRecord", resourceRecordValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DomainValidationRecord) extends DomainValidationRecord.ReadOnly {
    override def domainNameValue: scala.Option[primitives.DomainName] = scala.Option(impl.domainName()).map(value => value: primitives.DomainName)
    override def resourceRecordValue: scala.Option[ResourceRecord.ReadOnly] = scala.Option(impl.resourceRecord()).map(value => ResourceRecord.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DomainValidationRecord): ReadOnly = new Wrapper(impl)
}