package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteRelationalDatabaseSnapshotRequest(relationalDatabaseSnapshotName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest = {
    import DeleteRelationalDatabaseSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest.builder().relationalDatabaseSnapshotName(relationalDatabaseSnapshotName: java.lang.String).build()
  }
  def asReadOnly: DeleteRelationalDatabaseSnapshotRequest.ReadOnly = DeleteRelationalDatabaseSnapshotRequest.wrap(buildAwsValue())
}
object DeleteRelationalDatabaseSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteRelationalDatabaseSnapshotRequest = DeleteRelationalDatabaseSnapshotRequest(relationalDatabaseSnapshotNameValue)
    def relationalDatabaseSnapshotNameValue: primitives.ResourceName
    def relationalDatabaseSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseSnapshotNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest) extends DeleteRelationalDatabaseSnapshotRequest.ReadOnly { override def relationalDatabaseSnapshotNameValue: primitives.ResourceName = impl.relationalDatabaseSnapshotName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest): ReadOnly = new Wrapper(impl)
}