package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteKeyPairRequest(keyPairName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest = {
    import DeleteKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest.builder().keyPairName(keyPairName: java.lang.String).build()
  }
  def asReadOnly: DeleteKeyPairRequest.ReadOnly = DeleteKeyPairRequest.wrap(buildAwsValue())
}
object DeleteKeyPairRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteKeyPairRequest = DeleteKeyPairRequest(keyPairNameValue)
    def keyPairNameValue: primitives.ResourceName
    def keyPairName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(keyPairNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest) extends DeleteKeyPairRequest.ReadOnly { override def keyPairNameValue: primitives.ResourceName = impl.keyPairName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest): ReadOnly = new Wrapper(impl)
}