package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteInstanceRequest(instanceName: primitives.ResourceName, forceDeleteAddOns: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest = {
    import DeleteInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest.builder().instanceName(instanceName: java.lang.String).optionallyWith(forceDeleteAddOns.map(value => value: java.lang.Boolean))(_.forceDeleteAddOns).build()
  }
  def asReadOnly: DeleteInstanceRequest.ReadOnly = DeleteInstanceRequest.wrap(buildAwsValue())
}
object DeleteInstanceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteInstanceRequest = DeleteInstanceRequest(instanceNameValue, forceDeleteAddOnsValue.map(value => value))
    def instanceNameValue: primitives.ResourceName
    def forceDeleteAddOnsValue: scala.Option[Boolean]
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
    def forceDeleteAddOns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forceDeleteAddOns", forceDeleteAddOnsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest) extends DeleteInstanceRequest.ReadOnly {
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
    override def forceDeleteAddOnsValue: scala.Option[Boolean] = scala.Option(impl.forceDeleteAddOns()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest): ReadOnly = new Wrapper(impl)
}