package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteDistributionRequest(distributionName: scala.Option[primitives.ResourceName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest = {
    import DeleteDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest.builder().optionallyWith(distributionName.map(value => value: java.lang.String))(_.distributionName).build()
  }
  def asReadOnly: DeleteDistributionRequest.ReadOnly = DeleteDistributionRequest.wrap(buildAwsValue())
}
object DeleteDistributionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteDistributionRequest = DeleteDistributionRequest(distributionNameValue.map(value => value))
    def distributionNameValue: scala.Option[primitives.ResourceName]
    def distributionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("distributionName", distributionNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest) extends DeleteDistributionRequest.ReadOnly { override def distributionNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.distributionName()).map(value => value: primitives.ResourceName) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest): ReadOnly = new Wrapper(impl)
}