package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ContainerServiceMetricName { def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName }
object ContainerServiceMetricName {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName): ContainerServiceMetricName = value match {
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.CPU_UTILIZATION =>
      val r = CPUUtilization
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.MEMORY_UTILIZATION =>
      val r = MemoryUtilization
      r
  }
  case object unknownToSdkVersion extends ContainerServiceMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName = software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.UNKNOWN_TO_SDK_VERSION }
  case object CPUUtilization extends ContainerServiceMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName = software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.CPU_UTILIZATION }
  case object MemoryUtilization extends ContainerServiceMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName = software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.MEMORY_UTILIZATION }
}