package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait CloudFormationStackRecordSourceType { def unwrap: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType }
object CloudFormationStackRecordSourceType {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType): CloudFormationStackRecordSourceType = value match {
    case software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType.EXPORT_SNAPSHOT_RECORD =>
      val r = ExportSnapshotRecord
      r
  }
  case object unknownToSdkVersion extends CloudFormationStackRecordSourceType { override def unwrap: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType = software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType.UNKNOWN_TO_SDK_VERSION }
  case object ExportSnapshotRecord extends CloudFormationStackRecordSourceType { override def unwrap: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType = software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType.EXPORT_SNAPSHOT_RECORD }
}