package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Blueprint(blueprintId: scala.Option[primitives.NonEmptyString] = None, name: scala.Option[primitives.ResourceName] = None, group: scala.Option[primitives.NonEmptyString] = None, `type`: scala.Option[BlueprintType] = None, description: scala.Option[String] = None, isActive: scala.Option[Boolean] = None, minPower: scala.Option[primitives.Integer] = None, version: scala.Option[String] = None, versionCode: scala.Option[String] = None, productUrl: scala.Option[String] = None, licenseUrl: scala.Option[String] = None, platform: scala.Option[InstancePlatform] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Blueprint = {
    import Blueprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Blueprint.builder().optionallyWith(blueprintId.map(value => value: java.lang.String))(_.blueprintId).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(group.map(value => value: java.lang.String))(_.group).optionallyWith(`type`.map(value => value.unwrap))(_.`type`).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(isActive.map(value => value: java.lang.Boolean))(_.isActive).optionallyWith(minPower.map(value => value: java.lang.Integer))(_.minPower).optionallyWith(version.map(value => value: java.lang.String))(_.version).optionallyWith(versionCode.map(value => value: java.lang.String))(_.versionCode).optionallyWith(productUrl.map(value => value: java.lang.String))(_.productUrl).optionallyWith(licenseUrl.map(value => value: java.lang.String))(_.licenseUrl).optionallyWith(platform.map(value => value.unwrap))(_.platform).build()
  }
  def asReadOnly: Blueprint.ReadOnly = Blueprint.wrap(buildAwsValue())
}
object Blueprint {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Blueprint] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Blueprint = Blueprint(blueprintIdValue.map(value => value), nameValue.map(value => value), groupValue.map(value => value), typeValue.map(value => value), descriptionValue.map(value => value), isActiveValue.map(value => value), minPowerValue.map(value => value), versionValue.map(value => value), versionCodeValue.map(value => value), productUrlValue.map(value => value), licenseUrlValue.map(value => value), platformValue.map(value => value))
    def blueprintIdValue: scala.Option[primitives.NonEmptyString]
    def nameValue: scala.Option[primitives.ResourceName]
    def groupValue: scala.Option[primitives.NonEmptyString]
    def typeValue: scala.Option[BlueprintType]
    def descriptionValue: scala.Option[String]
    def isActiveValue: scala.Option[Boolean]
    def minPowerValue: scala.Option[primitives.Integer]
    def versionValue: scala.Option[String]
    def versionCodeValue: scala.Option[String]
    def productUrlValue: scala.Option[String]
    def licenseUrlValue: scala.Option[String]
    def platformValue: scala.Option[InstancePlatform]
    def blueprintId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("blueprintId", blueprintIdValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def group: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("group", groupValue)
    def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, BlueprintType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def isActive: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isActive", isActiveValue)
    def minPower: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minPower", minPowerValue)
    def version: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("version", versionValue)
    def versionCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("versionCode", versionCodeValue)
    def productUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productUrl", productUrlValue)
    def licenseUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseUrl", licenseUrlValue)
    def platform: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstancePlatform] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("platform", platformValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Blueprint) extends Blueprint.ReadOnly {
    override def blueprintIdValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.blueprintId()).map(value => value: primitives.NonEmptyString)
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def groupValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.group()).map(value => value: primitives.NonEmptyString)
    override def typeValue: scala.Option[BlueprintType] = scala.Option(impl.`type`()).map(value => BlueprintType.wrap(value))
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def isActiveValue: scala.Option[Boolean] = scala.Option(impl.isActive()).map(value => value: Boolean)
    override def minPowerValue: scala.Option[primitives.Integer] = scala.Option(impl.minPower()).map(value => value: primitives.Integer)
    override def versionValue: scala.Option[String] = scala.Option(impl.version()).map(value => value: String)
    override def versionCodeValue: scala.Option[String] = scala.Option(impl.versionCode()).map(value => value: String)
    override def productUrlValue: scala.Option[String] = scala.Option(impl.productUrl()).map(value => value: String)
    override def licenseUrlValue: scala.Option[String] = scala.Option(impl.licenseUrl()).map(value => value: String)
    override def platformValue: scala.Option[InstancePlatform] = scala.Option(impl.platform()).map(value => InstancePlatform.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Blueprint): ReadOnly = new Wrapper(impl)
}