package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Alarm(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, supportCode: scala.Option[String] = None, monitoredResourceInfo: scala.Option[MonitoredResourceInfo] = None, comparisonOperator: scala.Option[ComparisonOperator] = None, evaluationPeriods: scala.Option[primitives.Integer] = None, period: scala.Option[primitives.MetricPeriod] = None, threshold: scala.Option[Double] = None, datapointsToAlarm: scala.Option[primitives.Integer] = None, treatMissingData: scala.Option[TreatMissingData] = None, statistic: scala.Option[MetricStatistic] = None, metricName: scala.Option[MetricName] = None, state: scala.Option[AlarmState] = None, unit: scala.Option[MetricUnit] = None, contactProtocols: scala.Option[Iterable[ContactProtocol]] = None, notificationTriggers: scala.Option[Iterable[AlarmState]] = None, notificationEnabled: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Alarm = {
    import Alarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Alarm.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(monitoredResourceInfo.map(value => value.buildAwsValue()))(_.monitoredResourceInfo).optionallyWith(comparisonOperator.map(value => value.unwrap))(_.comparisonOperator).optionallyWith(evaluationPeriods.map(value => value: java.lang.Integer))(_.evaluationPeriods).optionallyWith(period.map(value => value: java.lang.Integer))(_.period).optionallyWith(threshold.map(value => value: java.lang.Double))(_.threshold).optionallyWith(datapointsToAlarm.map(value => value: java.lang.Integer))(_.datapointsToAlarm).optionallyWith(treatMissingData.map(value => value.unwrap))(_.treatMissingData).optionallyWith(statistic.map(value => value.unwrap))(_.statistic).optionallyWith(metricName.map(value => value.unwrap))(_.metricName).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(unit.map(value => value.unwrap))(_.unit).optionallyWith(contactProtocols.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.contactProtocolsWithStrings).optionallyWith(notificationTriggers.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.notificationTriggersWithStrings).optionallyWith(notificationEnabled.map(value => value: java.lang.Boolean))(_.notificationEnabled).build()
  }
  def asReadOnly: Alarm.ReadOnly = Alarm.wrap(buildAwsValue())
}
object Alarm {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Alarm] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Alarm = Alarm(nameValue.map(value => value), arnValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), supportCodeValue.map(value => value), monitoredResourceInfoValue.map(value => value.editable), comparisonOperatorValue.map(value => value), evaluationPeriodsValue.map(value => value), periodValue.map(value => value), thresholdValue.map(value => value), datapointsToAlarmValue.map(value => value), treatMissingDataValue.map(value => value), statisticValue.map(value => value), metricNameValue.map(value => value), stateValue.map(value => value), unitValue.map(value => value), contactProtocolsValue.map(value => value), notificationTriggersValue.map(value => value), notificationEnabledValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def supportCodeValue: scala.Option[String]
    def monitoredResourceInfoValue: scala.Option[MonitoredResourceInfo.ReadOnly]
    def comparisonOperatorValue: scala.Option[ComparisonOperator]
    def evaluationPeriodsValue: scala.Option[primitives.Integer]
    def periodValue: scala.Option[primitives.MetricPeriod]
    def thresholdValue: scala.Option[Double]
    def datapointsToAlarmValue: scala.Option[primitives.Integer]
    def treatMissingDataValue: scala.Option[TreatMissingData]
    def statisticValue: scala.Option[MetricStatistic]
    def metricNameValue: scala.Option[MetricName]
    def stateValue: scala.Option[AlarmState]
    def unitValue: scala.Option[MetricUnit]
    def contactProtocolsValue: scala.Option[List[ContactProtocol]]
    def notificationTriggersValue: scala.Option[List[AlarmState]]
    def notificationEnabledValue: scala.Option[Boolean]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def monitoredResourceInfo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MonitoredResourceInfo.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoredResourceInfo", monitoredResourceInfoValue)
    def comparisonOperator: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ComparisonOperator] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("comparisonOperator", comparisonOperatorValue)
    def evaluationPeriods: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriodsValue)
    def period: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MetricPeriod] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("period", periodValue)
    def threshold: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Double] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("threshold", thresholdValue)
    def datapointsToAlarm: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarmValue)
    def treatMissingData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TreatMissingData] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("treatMissingData", treatMissingDataValue)
    def statistic: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MetricStatistic] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("statistic", statisticValue)
    def metricName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MetricName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metricName", metricNameValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AlarmState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def unit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MetricUnit] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unit", unitValue)
    def contactProtocols: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ContactProtocol]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("contactProtocols", contactProtocolsValue)
    def notificationTriggers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AlarmState]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notificationTriggers", notificationTriggersValue)
    def notificationEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notificationEnabled", notificationEnabledValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Alarm) extends Alarm.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def monitoredResourceInfoValue: scala.Option[MonitoredResourceInfo.ReadOnly] = scala.Option(impl.monitoredResourceInfo()).map(value => MonitoredResourceInfo.wrap(value))
    override def comparisonOperatorValue: scala.Option[ComparisonOperator] = scala.Option(impl.comparisonOperator()).map(value => ComparisonOperator.wrap(value))
    override def evaluationPeriodsValue: scala.Option[primitives.Integer] = scala.Option(impl.evaluationPeriods()).map(value => value: primitives.Integer)
    override def periodValue: scala.Option[primitives.MetricPeriod] = scala.Option(impl.period()).map(value => value: primitives.MetricPeriod)
    override def thresholdValue: scala.Option[Double] = scala.Option(impl.threshold()).map(value => value: Double)
    override def datapointsToAlarmValue: scala.Option[primitives.Integer] = scala.Option(impl.datapointsToAlarm()).map(value => value: primitives.Integer)
    override def treatMissingDataValue: scala.Option[TreatMissingData] = scala.Option(impl.treatMissingData()).map(value => TreatMissingData.wrap(value))
    override def statisticValue: scala.Option[MetricStatistic] = scala.Option(impl.statistic()).map(value => MetricStatistic.wrap(value))
    override def metricNameValue: scala.Option[MetricName] = scala.Option(impl.metricName()).map(value => MetricName.wrap(value))
    override def stateValue: scala.Option[AlarmState] = scala.Option(impl.state()).map(value => AlarmState.wrap(value))
    override def unitValue: scala.Option[MetricUnit] = scala.Option(impl.unit()).map(value => MetricUnit.wrap(value))
    override def contactProtocolsValue: scala.Option[List[ContactProtocol]] = scala.Option(impl.contactProtocols()).map(value => value.asScala.map { item => 
      ContactProtocol.wrap(item)
    }.toList)
    override def notificationTriggersValue: scala.Option[List[AlarmState]] = scala.Option(impl.notificationTriggers()).map(value => value.asScala.map { item => 
      AlarmState.wrap(item)
    }.toList)
    override def notificationEnabledValue: scala.Option[Boolean] = scala.Option(impl.notificationEnabled()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Alarm): ReadOnly = new Wrapper(impl)
}