package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AccessKey(accessKeyId: scala.Option[primitives.IAMAccessKeyId] = None, secretAccessKey: scala.Option[primitives.NonEmptyString] = None, status: scala.Option[StatusType] = None, createdAt: scala.Option[primitives.IsoDate] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AccessKey = {
    import AccessKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccessKey.builder().optionallyWith(accessKeyId.map(value => value: java.lang.String))(_.accessKeyId).optionallyWith(secretAccessKey.map(value => value: java.lang.String))(_.secretAccessKey).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).build()
  }
  def asReadOnly: AccessKey.ReadOnly = AccessKey.wrap(buildAwsValue())
}
object AccessKey {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AccessKey] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AccessKey = AccessKey(accessKeyIdValue.map(value => value), secretAccessKeyValue.map(value => value), statusValue.map(value => value), createdAtValue.map(value => value))
    def accessKeyIdValue: scala.Option[primitives.IAMAccessKeyId]
    def secretAccessKeyValue: scala.Option[primitives.NonEmptyString]
    def statusValue: scala.Option[StatusType]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def accessKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IAMAccessKeyId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessKeyId", accessKeyIdValue)
    def secretAccessKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("secretAccessKey", secretAccessKeyValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, StatusType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AccessKey) extends AccessKey.ReadOnly {
    override def accessKeyIdValue: scala.Option[primitives.IAMAccessKeyId] = scala.Option(impl.accessKeyId()).map(value => value: primitives.IAMAccessKeyId)
    override def secretAccessKeyValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.secretAccessKey()).map(value => value: primitives.NonEmptyString)
    override def statusValue: scala.Option[StatusType] = scala.Option(impl.status()).map(value => StatusType.wrap(value))
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AccessKey): ReadOnly = new Wrapper(impl)
}