package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SendContactMethodVerificationRequest(protocol: ContactMethodVerificationProtocol) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest = {
    import SendContactMethodVerificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest.builder().protocol(protocol.unwrap).build()
  }
  def asReadOnly: SendContactMethodVerificationRequest.ReadOnly = SendContactMethodVerificationRequest.wrap(buildAwsValue())
}
object SendContactMethodVerificationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SendContactMethodVerificationRequest = SendContactMethodVerificationRequest(protocolValue)
    def protocolValue: ContactMethodVerificationProtocol
    def protocol: ZIO[Any, Nothing, ContactMethodVerificationProtocol] = ZIO.succeed(protocolValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest) extends SendContactMethodVerificationRequest.ReadOnly { override def protocolValue: ContactMethodVerificationProtocol = ContactMethodVerificationProtocol.wrap(impl.protocol()) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest): ReadOnly = new Wrapper(impl)
}