package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class QueryStringObject(option: scala.Option[Boolean] = None, queryStringsAllowList: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.QueryStringObject = {
    import QueryStringObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.QueryStringObject.builder().optionallyWith(option.map(value => value: java.lang.Boolean))(_.option).optionallyWith(queryStringsAllowList.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.queryStringsAllowList).build()
  }
  def asReadOnly: QueryStringObject.ReadOnly = QueryStringObject.wrap(buildAwsValue())
}
object QueryStringObject {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.QueryStringObject] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: QueryStringObject = QueryStringObject(optionValue.map(value => value), queryStringsAllowListValue.map(value => value))
    def optionValue: scala.Option[Boolean]
    def queryStringsAllowListValue: scala.Option[List[String]]
    def option: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("option", optionValue)
    def queryStringsAllowList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("queryStringsAllowList", queryStringsAllowListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.QueryStringObject) extends QueryStringObject.ReadOnly {
    override def optionValue: scala.Option[Boolean] = scala.Option(impl.option()).map(value => value: Boolean)
    override def queryStringsAllowListValue: scala.Option[List[String]] = scala.Option(impl.queryStringsAllowList()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.QueryStringObject): ReadOnly = new Wrapper(impl)
}