package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait NetworkProtocol { def unwrap: software.amazon.awssdk.services.lightsail.model.NetworkProtocol }
object NetworkProtocol {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.NetworkProtocol): NetworkProtocol = value match {
    case software.amazon.awssdk.services.lightsail.model.NetworkProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.NetworkProtocol.TCP =>
      val r = tcp
      r
    case software.amazon.awssdk.services.lightsail.model.NetworkProtocol.ALL =>
      val r = all
      r
    case software.amazon.awssdk.services.lightsail.model.NetworkProtocol.UDP =>
      val r = udp
      r
    case software.amazon.awssdk.services.lightsail.model.NetworkProtocol.ICMP =>
      val r = icmp
      r
  }
  case object unknownToSdkVersion extends NetworkProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.NetworkProtocol = software.amazon.awssdk.services.lightsail.model.NetworkProtocol.UNKNOWN_TO_SDK_VERSION }
  case object tcp extends NetworkProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.NetworkProtocol = software.amazon.awssdk.services.lightsail.model.NetworkProtocol.TCP }
  case object all extends NetworkProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.NetworkProtocol = software.amazon.awssdk.services.lightsail.model.NetworkProtocol.ALL }
  case object udp extends NetworkProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.NetworkProtocol = software.amazon.awssdk.services.lightsail.model.NetworkProtocol.UDP }
  case object icmp extends NetworkProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.NetworkProtocol = software.amazon.awssdk.services.lightsail.model.NetworkProtocol.ICMP }
}