package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class MonthlyTransfer(gbPerMonthAllocated: scala.Option[primitives.Integer] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.MonthlyTransfer = {
    import MonthlyTransfer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MonthlyTransfer.builder().optionallyWith(gbPerMonthAllocated.map(value => value: java.lang.Integer))(_.gbPerMonthAllocated).build()
  }
  def asReadOnly: MonthlyTransfer.ReadOnly = MonthlyTransfer.wrap(buildAwsValue())
}
object MonthlyTransfer {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.MonthlyTransfer] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: MonthlyTransfer = MonthlyTransfer(gbPerMonthAllocatedValue.map(value => value))
    def gbPerMonthAllocatedValue: scala.Option[primitives.Integer]
    def gbPerMonthAllocated: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("gbPerMonthAllocated", gbPerMonthAllocatedValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.MonthlyTransfer) extends MonthlyTransfer.ReadOnly { override def gbPerMonthAllocatedValue: scala.Option[primitives.Integer] = scala.Option(impl.gbPerMonthAllocated()).map(value => value: primitives.Integer) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.MonthlyTransfer): ReadOnly = new Wrapper(impl)
}