package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetKeyPairRequest(keyPairName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest = {
    import GetKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest.builder().keyPairName(keyPairName: java.lang.String).build()
  }
  def asReadOnly: GetKeyPairRequest.ReadOnly = GetKeyPairRequest.wrap(buildAwsValue())
}
object GetKeyPairRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetKeyPairRequest = GetKeyPairRequest(keyPairNameValue)
    def keyPairNameValue: primitives.ResourceName
    def keyPairName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(keyPairNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest) extends GetKeyPairRequest.ReadOnly { override def keyPairNameValue: primitives.ResourceName = impl.keyPairName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest): ReadOnly = new Wrapper(impl)
}