package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBlueprintsResponse(blueprints: scala.Option[Iterable[Blueprint]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse = {
    import GetBlueprintsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse.builder().optionallyWith(blueprints.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.blueprints).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetBlueprintsResponse.ReadOnly = GetBlueprintsResponse.wrap(buildAwsValue())
}
object GetBlueprintsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBlueprintsResponse = GetBlueprintsResponse(blueprintsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def blueprintsValue: scala.Option[List[Blueprint.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def blueprints: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Blueprint.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("blueprints", blueprintsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse) extends GetBlueprintsResponse.ReadOnly {
    override def blueprintsValue: scala.Option[List[Blueprint.ReadOnly]] = scala.Option(impl.blueprints()).map(value => value.asScala.map { item => 
      Blueprint.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse): ReadOnly = new Wrapper(impl)
}