package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteDiskRequest(diskName: primitives.ResourceName, forceDeleteAddOns: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest = {
    import DeleteDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest.builder().diskName(diskName: java.lang.String).optionallyWith(forceDeleteAddOns.map(value => value: java.lang.Boolean))(_.forceDeleteAddOns).build()
  }
  def asReadOnly: DeleteDiskRequest.ReadOnly = DeleteDiskRequest.wrap(buildAwsValue())
}
object DeleteDiskRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteDiskRequest = DeleteDiskRequest(diskNameValue, forceDeleteAddOnsValue.map(value => value))
    def diskNameValue: primitives.ResourceName
    def forceDeleteAddOnsValue: scala.Option[Boolean]
    def diskName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(diskNameValue)
    def forceDeleteAddOns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forceDeleteAddOns", forceDeleteAddOnsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest) extends DeleteDiskRequest.ReadOnly {
    override def diskNameValue: primitives.ResourceName = impl.diskName(): primitives.ResourceName
    override def forceDeleteAddOnsValue: scala.Option[Boolean] = scala.Option(impl.forceDeleteAddOns()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest): ReadOnly = new Wrapper(impl)
}